/**
  ********************************************************************************
  *
  * @file    hal_i2c.h
  * @brief   Header file of I2c driver
  *
  * @version V1.0
  * @data    22 Aug 2018
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  ********************************************************************************
  */

#ifndef __HAL_I2C_H__
#define __HAL_I2C_H__

#include "hic.h"
#include "type.h"

/**
  * @addtogroup ES7P203_HAL
  * @{
  */

/**
  * @addtogroup I2C
  * @{
  */

/**
  * @defgroup I2c_Public_Types i2c Public Types
  * @{
  */

/**
  * @brief I2c handle Structure definition
  */

typedef struct i2c_handle_s {
	uint8_t addr;	/**< Specific the device own address */
	uint8_t *buf;	/**< Pointer to I2C transfer buffer */
	uint16_t size;	/**< I2C Transfer counter */
	uint16_t count;	/**< I2C Transfer counter */
} i2c_handle_t;

/**
  * @defgroup I2c_Public_Micros i2c Public Micros
  * @{
  */

#define I2C_ENABLE	(I2CEN = 1)
#define I2C_DISABLE	(I2CEN = 0)
#define I2C_IT_ENABLE	(I2CIE = 1)
#define I2C_IT_DISABLE	(I2CIE = 0)

/**
  * @}
  */

/**
  * @addtogroup I2c_Public_Functions
  * @{
  */

extern hal_status_t i2c_reset(i2c_handle_t *hperh);
extern hal_status_t i2c_init(i2c_handle_t *hperh);
extern void irq_i2c_handle(i2c_handle_t *hperh);
extern hal_status_t i2c_tx_by_irq(i2c_handle_t *hperh, uint8_t *buf, uint8_t size);
extern hal_status_t i2c_rx_by_irq(i2c_handle_t *hperh, uint8_t *buf, uint8_t size);

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#endif
